float4x4 matWorldViewProjection; 

float2 texelsize; 
texture tex0; 
texture tex1; 

float ROCKET[64];

sampler2D base = sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

sampler2D depth_view = sampler_state
{
	texture = (tex1);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};


void vs_blit(in float4 ipos : POSITION,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	opos.x -= texelsize.x/2.f;
	opos.y -= texelsize.y/2.f;
	otex = 1-itex;
	//otex = otex.y;
};

float4 ps_blit(in float2 tex : TEXCOORD0) : COLOR0
{
	//return float4(1.f, 1.f, 0.f, .5f);
	return tex2D(base, tex);
	//return tex2D(base , tex);
};

float4 ps_paint(in float2 tex : TEXCOORD0) : COLOR0
{
	return float4(1.f, 0.f, 0.f, 0.f);
}

float4 ps_paint2(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(base, tex)*(1+tex2D(depth_view, tex))*ROCKET[7];
	return float4(0.f, 1.f, 0.f, 0.f);
}


technique General
{
	pass blit
	{
		vertexshader  = compile vs_2_0 vs_blit();
		pixelshader   = compile ps_2_0 ps_blit();
	}
	
	pass paint
	{
		vertexshader = compile vs_2_0 vs_blit();
		pixelshader  = compile ps_2_0 ps_paint(); 
	}
	
	pass lightblit
	{
		vertexshader = compile vs_2_0 vs_blit();
		pixelshader  = compile ps_2_0 ps_paint2();
	}
}


